<!-- breadcrumb -->
<div class="site-breadcrumb" style="background: url(<?php echo base_url(); ?>public/uploads/<?php echo $setting['banner_news']; ?>)">
	<div class="container">
		<h2 class="breadcrumb-title">News & Events</h2>
		<ul class="breadcrumb-menu">
			<li><a href="<?= base_url(); ?>">Home</a></li>
			<li class="active">News & Events</li>
		</ul>
	</div>
</div>
<!-- breadcrumb end -->

<!-- blog area -->
<div class="blog-area py-120">
	<div class="container">
		<div class="row">
			<div class="col-lg-9">
				<div class="row">
					<div class="col-lg-6 mx-auto">
						<div class="site-heading text-center">
							<span class="site-title-tagline"><i class="far fa-book-open-reader"></i> Our News & Events</span>
							<h2 class="site-title"><?php echo $page_news['news_heading']; ?></span></h2>
						</div>
					</div>
				</div>
				<div class="row">
					<?php
						foreach($news_fetched as $row) {
							?>
						<div class="col-md-6 col-lg-4">
							<div class="blog-item wow fadeInUp" data-wow-delay=".25s">
								<div class="blog-date"><i class="fal fa-calendar-alt"></i> <?= date('M d, Y',strtotime($row->news_date)) ?></div>
								<div class="blog-item-img">
									<img src="<?php echo base_url(); ?>public/uploads/<?php echo $row->photo; ?>" alt="Thumb">
								</div>
								<div class="blog-item-info">
									<div class="blog-item-meta">
										<ul>
											<li><a href="<?php echo base_url(); ?>category/<?php echo $row->category_id; ?>"><i class="far fa-list-alt"></i> <?php echo $row->category_name; ?></a></li>
											<!-- <li><a href="#"><i class="far fa-comments"></i> 03 Comments</a></li> -->
										</ul>
									</div>
									<h4 class="blog-title">
										<a href="<?php echo base_url(); ?>news/view/<?php echo $row->news_id; ?>"><?php echo $row->news_title; ?></a>
									</h4>
									<a class="theme-btn" href="<?php echo base_url(); ?>news/view/<?php echo $row->news_id; ?>">Read More<i class="fas fa-arrow-right-long"></i></a>
								</div>
							</div>
						</div>
					<?php
						}
						?>
				</div>
				<!-- pagination -->
				<div class="pagination-area">			
					<?php echo $links; ?>			
				</div>
				<!-- pagination end -->
			</div>
			<div class="col-lg-3">
				<aside class="sidebar">
					<!-- search-->
					<div class="widget search">
						<h5 class="widget-title">Search</h5>
						<?php echo form_open(base_url().'search',['class' => 'search-form']); ?>
							<input type="text" class="form-control" placeholder="<?php echo SEARCH_FOR; ?>"  name="search_string" autocomplete="off">
							<button type="submit"><i class="far fa-search"></i></button>
                        <?php echo form_close(); ?>
					</div>
					<!-- category -->
					<div class="widget category">
						<h5 class="widget-title"><?php echo SIDEBAR_NEWS_HEADING_1; ?></h5>
						<div class="category-list">
							<?php
                            foreach($all_categories as $row) {
                                ?>
								<a href="<?php echo base_url(); ?>category/<?php echo $row['category_id']; ?>"><i class="far fa-arrow-right"></i><?php echo $row['category_name']; ?><span>(<?= $row['news_count']; ?>)</span></a>
                                <?php
                            }
                            ?>
						</div>
					</div>
					<!-- recent post -->
					<div class="widget recent-post">
						<h5 class="widget-title"><?php echo SIDEBAR_NEWS_HEADING_2; ?></h5>
						<?php
                        $i=0;
                        foreach($news as $row) {
                            $i++;
                            if($i>$setting['sidebar_total_recent_post']) {
                                break;
                            }
                            ?>
							<div class="recent-post-single">
								<div class="recent-post-img">
									<img src="<?php echo base_url().'public/uploads/'.$row['photo']; ?>" alt="thumb">
								</div>
								<div class="recent-post-bio">
									<h6><a href="<?php echo base_url(); ?>news/view/<?php echo $row['news_id']; ?>"><?php echo $row['news_title']; ?></a></h6>
									<span><i class="far fa-clock"></i><?= date('M d, Y',strtotime($row['news_date'])) ?></span>
								</div>
							</div>
						<?php
						}
						?>						
					</div>
				</aside>
			</div>
		</div>
	</div>
</div>
<!-- blog area end -->
